import pickle

import pandas as pd
print(f"pandas: {pd.__version__}")
import numpy as np
print(f"numpy: {np.__version__}")

import datetime as dt

# Create .zip file
import zipfile

# Send to SCE
import requests

#########################################
# PARAMS BY HAND
#########################################
# Save options
DATA_INPUT_PATH_STR = "./" # f.eg "./model/"
DATA_OUTPUT_PATH_STR = "./" # f.eg "./deployment/"

# API Configuration
SCORING_CODE_NAME_STR = 'test_model_python'

# Endpoint
SCE_ENVIRONMENT_STR = 'demo' # f.eg demo
API_CODE_TYPE_STR = 'python'

# Key
API_KEY_STR = '' # ~ 36 characters

# Body, JSON (Optional)
BODY_DICT = {
    '': ''
    , '': ''
}

#########################################
# PARAMS AUTO-GENERATED
#########################################

API_ENVIRONMENT_URL_STR = f"https://{SCE_ENVIRONMENT_STR}.scoring.one"
API_FULL_URL_STR = f"{API_ENVIRONMENT_URL_STR}/api/{API_CODE_TYPE_STR}/code/create"

# Headers
HEADERS_DICT = {
    'Authorization': f"Bearer {API_KEY_STR}"
}
# Params
PARAMS_DICT = {
    'dateFrom': dt.datetime.now().strftime('%Y-%m-%d')
    , 'dateTo': dt.datetime.now().strftime('%Y-%m-%d')
    , 'fileName': 'model.zip'
    , 'scoringCodeName': SCORING_CODE_NAME_STR
    , 'charset': 'UTF-8'
}

#########################################
# CREATE NECESSARY FILES INSIDE .py SCRIPT (OPTIONAL)
#########################################

# # model.csv
# Create .csv file with SCE parameters.
# VARS_DEF_STR_TUPLE = (
#     "true" + ";" + "age" + ";" + "STRING" + ";;" + "\n"
#     "true" + ";" + "education" + ";" + "STRING" + ";;"
# )

# # Create model.csv
# with open(file = DATA_OUTPUT_PATH_STR 
#                   + "model" 
#                   + ".csv", 
#           mode = 'wt') as model_csv_file:

#     model_csv_file.write(VARS_DEF_STR_TUPLE)

# # model.pkl
# # Read object .pkl
# with open(file = DATA_INPUT_PATH_STR
#                   + "model"
#                   + ".pkl", 
#           mode = 'rb') as model_file:

#     model_pkl = pickle.load(model_file)

# # Save to deployment folder
# with open(file = DATA_OUTPUT_PATH_STR 
#                   + "model" 
#                   + ".pkl", 
#           mode = 'wb') as model_file:
#     pickle.dump(model_pkl, model_file)

# # model.py
# # Create model.py file for processing events on SCE.
# with open(file = DATA_OUTPUT_PATH_STR 
#                   + "model" 
#                   + ".py", 
#           mode = 'wt') as model_py_file:

#     model_py_file.write(f'''

# # Created: {dt.datetime.now().strftime('%Y-%m-%d %H:%M:%S')}

# import pandas as pd

# return None

#     ''')


#########################################
# SAVE TO .ZIP
#########################################
# Create .zip file to send it to SCE.
model_zip_file = zipfile.ZipFile(
    file = DATA_OUTPUT_PATH_STR + 'model.zip'
    , mode = "w"
    , compression = zipfile.ZIP_DEFLATED
)
model_zip_file.write(
    filename = DATA_OUTPUT_PATH_STR + 'model.csv'
    , arcname = 'model.csv'
)
model_zip_file.write(
    filename = DATA_OUTPUT_PATH_STR + 'model.py'
    , arcname = 'model.py'
)
model_zip_file.write(
    filename = DATA_OUTPUT_PATH_STR + 'model.pkl'
    , arcname = 'model.pkl'
)
model_zip_file.close()

#########################################
# DEPLOY TO SCORING.ONE
#########################################
with open(file = DATA_OUTPUT_PATH_STR 
                  + "model" 
                  + ".zip", 
          mode = 'rb') as model_zip_file:

    response_obj = requests.post(
        url = API_FULL_URL_STR
        , data = PARAMS_DICT
        , headers = HEADERS_DICT
        , files = {"file": (DATA_OUTPUT_PATH_STR + 'model.zip', model_zip_file)}
    )

print(response_obj.text)
print("Model have been successfully deployed!")